<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Top_Charity
 */

if ( ! is_front_page() || is_home() ) { ?>
		</div>
	</div>
</div><!-- #content -->
<?php } ?>

<footer id="colophon" class="site-footer">
	<div class="site-footer-top">
		<div class="ascendoor-wrapper">
			<div class="footer-widgets-wrapper">

				<?php for ( $i = 1; $i <= 4; $i++ ) { ?>

					<div class="footer-widget-single">
						<?php dynamic_sidebar( 'footer-widget-' . $i ); ?>
					</div>

				<?php } ?>

			</div>
		</div>
	</div><!-- .footer-top -->
	<div class="site-footer-bottom">
		<div class="ascendoor-wrapper">
			<div class="site-footer-bottom-wrapper">
				<div class="site-info">
					<?php
					/**
					 * Hook: top_charity_footer_copyright.
					 *
					 * @hooked - top_charity_output_footer_copyright_content - 10
					 */
					do_action( 'top_charity_footer_copyright' );
					?>
				</div><!-- .site-info -->
			</div>
		</div>
	</div>
</footer><!-- #colophon -->

<?php
$is_scroll_top_active = get_theme_mod( 'top_charity_scroll_top', true );
if ( $is_scroll_top_active ) :
	?>
	<a href="#" id="scroll-to-top" class="top-charity-scroll-to-top"><i class="fas fa-chevron-up"></i></a>
	<?php
endif;
?>
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>
