<?php

/**
 * Post Options
 *
 * @package Top_Charity
 */

$wp_customize->add_section(
	'top_charity_post_options',
	array(
		'title' => esc_html__( 'Post Options', 'top-charity' ),
		'panel' => 'top_charity_theme_options',
	)
);

// Post Options - Hide Date.
$wp_customize->add_setting(
	'top_charity_post_hide_date',
	array(
		'default'           => false,
		'sanitize_callback' => 'top_charity_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Top_Charity_Toggle_Switch_Custom_Control(
		$wp_customize,
		'top_charity_post_hide_date',
		array(
			'label'   => esc_html__( 'Hide Date', 'top-charity' ),
			'section' => 'top_charity_post_options',
		)
	)
);

// Post Options - Hide Author.
$wp_customize->add_setting(
	'top_charity_post_hide_author',
	array(
		'default'           => false,
		'sanitize_callback' => 'top_charity_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Top_Charity_Toggle_Switch_Custom_Control(
		$wp_customize,
		'top_charity_post_hide_author',
		array(
			'label'   => esc_html__( 'Hide Author', 'top-charity' ),
			'section' => 'top_charity_post_options',
		)
	)
);

// Post Options - Hide Category.
$wp_customize->add_setting(
	'top_charity_post_hide_category',
	array(
		'default'           => false,
		'sanitize_callback' => 'top_charity_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Top_Charity_Toggle_Switch_Custom_Control(
		$wp_customize,
		'top_charity_post_hide_category',
		array(
			'label'   => esc_html__( 'Hide Category', 'top-charity' ),
			'section' => 'top_charity_post_options',
		)
	)
);

// Post Options - Hide Tag.
$wp_customize->add_setting(
	'top_charity_post_hide_tags',
	array(
		'default'           => false,
		'sanitize_callback' => 'top_charity_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Top_Charity_Toggle_Switch_Custom_Control(
		$wp_customize,
		'top_charity_post_hide_tags',
		array(
			'label'   => esc_html__( 'Hide Tag', 'top-charity' ),
			'section' => 'top_charity_post_options',
		)
	)
);

// Post Options - Related Post Label.
$wp_customize->add_setting(
	'top_charity_post_related_post_label',
	array(
		'default'           => __( 'Related Posts', 'top-charity' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'top_charity_post_related_post_label',
	array(
		'label'    => esc_html__( 'Related Posts Label', 'top-charity' ),
		'section'  => 'top_charity_post_options',
		'settings' => 'top_charity_post_related_post_label',
		'type'     => 'text',
	)
);

// Post Options - Hide Related Posts.
$wp_customize->add_setting(
	'top_charity_post_hide_related_posts',
	array(
		'default'           => false,
		'sanitize_callback' => 'top_charity_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Top_Charity_Toggle_Switch_Custom_Control(
		$wp_customize,
		'top_charity_post_hide_related_posts',
		array(
			'label'   => esc_html__( 'Hide Related Posts', 'top-charity' ),
			'section' => 'top_charity_post_options',
		)
	)
);
